%Fonction de dilatation d'une image Im par un lment structurant El
function Im_Result = mydilate_quick(Im, El)
    Im_Result = Im - Im;

    im_hauteur = size(Im, 1);
    im_largeur = size(Im, 2);
    
    ox = (size(El, 2)+1)/2;
    oy = (size(El, 1)+1)/2;
    
    %On ne dilatera que les pixels non nuls
    pix = find(Im>0);
    
    for k=1:numel(pix)
        j = mod(pix(k)-1, size(Im,1)) +1;
        i = floor((pix(k)-1)/size(Im,1)) +1;
    
    %On parcourt l'image d'entre
            %Et on cherche, pour tous les points de l'lment structurant
            %appliqu au point (j,i) le maximum
            
            %Les coordonnes de l'image Im  considrer
            start_l = max(i-ox+1, 1);
            end_l = min(i+ox-1, im_largeur);
            start_h = max(j-oy+1, 1);
            end_h = min(j+oy-1, im_hauteur);
            
            %Les coordonnes de l'lment structurant  considrer
            start_el_l = ox - (i - start_l);
            end_el_l = (end_l - i) + ox;
            start_el_h = oy - (j - start_h);
            end_el_h = (end_h - j) + oy;
            
            Im_Result(start_h:end_h, start_l:end_l) = max(Im_Result(start_h:end_h, start_l:end_l), uint8(El(start_el_h:end_el_h, start_el_l:end_el_l))*Im(j,i));
    end
    
    
