%Fonction permettant de gnrer un lment structurant
%type doit tre gal  'square', 'diamond', 'disk', ou 'line'
%Pour 'square', spcifier ensuite la longueur du ct c du carr
%Pour 'diamond', prciser la longueur du demi-ct c du diamant (qui sera
%de longueur 2*c+1)
%Pour 'disk', spcifier le rayon du cercle
%Pour 'line', spcifier la longueur du segment et l'angle (en degr) avec l'axe
%horizontal
function Res = mystrel(type, varargin)

    switch type
        
        case 'line'
            if(length(varargin)<2)
                error('Option line requires two extra parameters.');
            end
            
            d=varargin{1};
            a=varargin{2};

            %On place l'angle dans un intervalle entre 90 et -90
            while (a > 90)
                a = a - 180;
            end

            while (a < -90)
                a = a + 180;
            end


            %Si l'angle est suprieur  45, on retire 90 et on
            %tournera le rsultat...
            rot=0;
            if a>45
                a = a-90;
                rot=1;
            elseif a<-45
                a = a+90;
                rot=3;
            end


            %Conversion de l'angle en radian
            a=a*pi/180;

            %Calcul de la taille de l'lment structurant en fonction de d
            lx = ceil(d/sqrt(1+tan(a)*tan(a)));
            ly = ceil(d*tan(abs(a))/sqrt(1+tan(a)*tan(a)));

            %Allocation du rsultat
            Res = zeros(ly,lx);

            %Coordonnes du centre
            mx = (size(Res,2)+1)/2;
            my = (size(Res,1)+1)/2;

            %Algo de Bresenham
            for i=1:size(Res,2)
                x = i - mx;
                y = tan(a)*x;
                Res(size(Res,1)-uint32(y+my)+1, i)=1;
            end

            Res=rot90(Res, rot); %Rotation si c'tait ncessaire (angle en dehors de [-45,45]
            
            
        case 'disk'
            if(length(varargin)<1)
                error('Option disk requires one extra parameter.');
            end
            
            R=varargin{1};
            
            %On construit l'image de sortie
            Res = zeros(2*R,2*R);

            %On construit 1/8 du disque, en testant les points x,y et voyant s'ils
            %appartiennent au disque (ils appartiennent si le disque touche le pixel)
            for x=R:2*R
                for y=R:x
                    if( (x-R-0.5)*(x-R-0.5) + (y-R-0.5)*(y-R-0.5) <= R*R )
                        Res(y,x)=1;
                    end
                end
            end

            %On construit les 7/8 restant du disque par symmtrie
            Res = max(Res, Res');
            Res = max(Res, rot90(Res, 1));
            Res = max(Res, rot90(Res, 2));
            Res = max(Res, rot90(Res, 3));
            
        
        case 'square'
            if(length(varargin)<1)
                error('Option square requires one extra parameter.');
            end
            
            C=varargin{1};
            
            %On construit l'image de sortie
            Res = ones(C,C);

            
            
            
        case 'diamond'
            if(length(varargin)<1)
                error('Option diamond requires one extra parameter.');
            end
            
            L=varargin{1};
            
            Res = zeros(2*L+1,2*L+1);
            
            %On construit 1/8 du diamant en allumant les pixels appartenant
            % chaque ligne du diamant
            for x=L+1:2*L+1
                Res(L+1:3*L-x+2,x)=1;
            end
            
            Res = max(Res, rot90(Res, 1));
            Res = max(Res, rot90(Res, 2));
            Res = max(Res, rot90(Res, 3));
            
            
            
        otherwise
            error('Required option has not yet been implemented.');
    end