%Fonction de dilatation d'une image Im par un lment structurant El
function Im_Result = mydilate(Im, El)
    El = rot90(El,2);
    Im_Result = Im;

    im_hauteur = size(Im, 1);
    im_largeur = size(Im, 2);
    
    ox = (size(El, 2)+1)/2;
    oy = (size(El, 1)+1)/2;
    
    %On parcourt l'image d'entre
    for j=1:im_hauteur
        for i=1:im_largeur
            %Et on cherche, pour tous les points de l'lment structurant
            %appliqu au point (j,i) le maximum
            
            %Les coordonnes de l'image Im  considrer
            start_l = max(i-ox+1, 1);
            end_l = min(i+ox-1, im_largeur);
            start_h = max(j-oy+1, 1);
            end_h = min(j+oy-1, im_hauteur);
            
            %Les coordonnes de l'lment structurant  considrer
            start_el_l = ox - (i - start_l);
            end_el_l = (end_l - i) + ox;
            start_el_h = oy - (j - start_h);
            end_el_h = (end_h - j) + oy;
            
            Im_Result(j,i) = max(max(double(Im(start_h:end_h, start_l:end_l)).*El(start_el_h:end_el_h, start_el_l:end_el_l)));
        end
    end
    
    
