function BVP=BVP_genCL03(nu,k)
  if nargin<=1,k=2;end
  if nargin==0,nu=0.5;end
  BVP.a=-1;BVP.b=1;
  BVP.t0=0;BVP.T=1;
  BVP.nu=nu;
  % vectorisation en x
  BVP.uex=@(t,x) cos(k*t)*cos(t+k*x);
  dt_uex=@(t,x) -k*cos(k*x + t)*sin(k*t) - cos(k*t)*sin(k*x + t);
  dx_uex=@(t,x) -k*cos(k*t)*sin(k*x + t);
  d2x_uex=@(t,x) -k^2*cos(k*t)*cos(k*x + t);
  BVP.f=@(t,x) dt_uex(t,x)-BVP.nu*d2x_uex(t,x);
  BVP.u0=@(x) BVP.uex(BVP.t0,x);
  BVP.delta_a=1;
  BVP.mu_a=-1; % <= 0
  BVP.delta_b=1;
  BVP.mu_b=2; % >= 0
  BVP.ga=@(t) BVP.delta_a*BVP.uex(t,BVP.a)+BVP.mu_a*dx_uex(t,BVP.a);
  BVP.gb=@(t) BVP.delta_b*BVP.uex(t,BVP.b)+BVP.mu_b*dx_uex(t,BVP.b);
end
