function BVP=BVP_DirichletCL01(nu,k)
  if nargin<=1,k=3;end
  if nargin==0,nu=1;end
  BVP.a=0;BVP.b=2*pi;
  BVP.t0=0;BVP.T=2;
  BVP.nu=nu;
  % vectorisation en x
  BVP.uex=@(t,x) cos(k*t)*cos(x);
  dt_uex=@(t,x) -k*cos(x)*sin(k*t);
  dx_uex=@(t,x) -cos(k*t)*sin(x);
  d2x_uex=@(t,x) -cos(k*t)*cos(x);
  BVP.f=@(t,x) dt_uex(t,x)-BVP.nu*d2x_uex(t,x);
  BVP.u0=@(x) BVP.uex(BVP.t0,x);
  BVP.ga=@(t) BVP.uex(t,BVP.a);
  BVP.gb=@(t) BVP.uex(t,BVP.b);
end
