function BVP=BVP_DirichletCL02(nu,k)
  if nargin<=1,k=2;end
  if nargin==0,nu=0.5;end
  BVP.a=-1;BVP.b=1;
  BVP.t0=0;BVP.T=1;
  BVP.nu=nu;
  % vectorisation en x
  BVP.uex=@(t,x) cos(k*t+t^2*x.^2-3*x.^2);
  dt_uex=@(t,x) -(2*t*x.^2 + k).*sin(t^2*x.^2 + k*t - 3*x.^2);
  dx_uex=@(t,x) -2*(t^2*x - 3*x).*sin(t^2*x.^2 + k*t - 3*x.^2);
  d2x_uex=@(t,x) -4*(t^2*x - 3*x).^2.*cos(t^2*x.^2 + k*t - 3*x.^2) - 2*(t^2 - 3)*sin(t^2*x.^2 + k*t - 3*x.^2);
  BVP.f=@(t,x) dt_uex(t,x)-BVP.nu*d2x_uex(t,x);
  BVP.u0=@(x) BVP.uex(BVP.t0,x);
  BVP.ga=@(t) BVP.uex(t,BVP.a);
  BVP.gb=@(t) BVP.uex(t,BVP.b);
end
