function BVP=BVP_genCL01(nu,k)
  if nargin<=1,k=5;end
  if nargin==0,nu=2;end

  BVP.a=0;BVP.b=2*pi;
  BVP.t0=0;BVP.T=2;
  BVP.nu=nu;
  BVP.uex=@(t,x) cos(k*t)*cos(x);
  dx_uex=@(t,x) -cos(k*t)*sin(x);
  BVP.f=@(t,x) -k*sin(k*t)*cos(x)+BVP.nu*cos(k*t)*cos(x);
  BVP.u0=@(x) BVP.uex(BVP.t0,x);
  BVP.delta_a=1;
  BVP.mu_a=-1; % <= 0
  BVP.delta_b=1;
  BVP.mu_b=2; % >= 0
  BVP.ga=@(t) BVP.delta_a*BVP.uex(t,BVP.a)+BVP.mu_a*dx_uex(t,BVP.a);
  BVP.gb=@(t) BVP.delta_b*BVP.uex(t,BVP.b)+BVP.mu_b*dx_uex(t,BVP.b);

end
