clear all
close all

PLOT = 1;
FREQ = 20;

% 1. Initialisation de la structure BVP
BVP.a=0;BVP.b=2*pi;
BVP.t0=0;BVP.T=2;
BVP.nu=2;
k=5;
BVP.uex=@(t,x) cos(k*t)*cos(x);
BVP.f=@(t,x) -k*sin(k*t)*cos(x)+BVP.nu*cos(k*t)*cos(x);
BVP.u0=@(x) BVP.uex(BVP.t0,x);
BVP.ga=@(t) BVP.uex(t,BVP.a);
BVP.gb=@(t) BVP.uex(t,BVP.b);

% 2. Parametres de discretisation

Nx=100;
Nt=2100;% => 2000 ?

% 3. Verification de la condition de C.F.L.
ht=BVP.T/Nt; hx=(BVP.b-BVP.a)/Nx;
CFL=BVP.nu*ht/(hx^2);
if CFL<=0.5
  fprintf('CFL = %f <= 0.5 => convergence\n',CFL);
else
  fprintf('CFL = %f > 0.5 => divergence\n',CFL);
end


% 4. Resolution par le schema d'EULER explicite
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Fonction non fournie : A IMPLEMENTER
disp('Calcul en cours...')
[t,x,u]=heat1d.explicit.Euler_DirichletCL(BVP,Nt,Nx);
disp('Fin du calcul.')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Uex=fsftx1d.eval(BVP.uex,t,x); % Solution exacte
Err=abs(u-Uex);
Ninf=fsftx1d.norm(Err,Inf);
fprintf('Erreur relative  (max en temps et espace) : %e\n',max(Ninf)/max(max(abs(Uex))));

% 4. Representations graphiques
if PLOT
  MIN=min(min(Uex));
  MAX=max(max(Uex));

  figure(1)
  fsftx1d.plot(t,x,u,'freq',FREQ,'title','Sol. Appr.','axis',[x(1) x(end) MIN MAX],'pause',0.1)

  MAX=max(max(Err));
  if MAX >1, AXIS=[]; else, AXIS=[x(1) x(end) 0 MAX];end

  figure(2)
  fsftx1d.plot(t,x,Err,'freq',FREQ,'title','Erreur','axis',AXIS,'pause',0.1)

  figure(3)
  plot(t,Ninf);
  xlabel('t')
  title('Erreur en norme L^\infty en espace')
end
