function lbe=EdgeLengthOpt(be,q)
% function lbe=EdgeLength(be,q)
%   Computation of the lengths of edges in the mesh
%   - Optimized version
%
% Parameters:
%  be: Connectivity array for boundary edges, 2-by-nbe array (int32).
%      be(il,l) is the storage index of the il-th  vertex 
%      of the l-th edge in the array q of vertices coordinates,
%      il in {1,2} and l in {1,...,nbe}.
%  q: Array of vertices coordinates, 2-by-nq array (double).
%     q(il,j) is the il-th coordinate of the j-th vertex, il in {1,2}
%     and j in {1,...,nq}.
% 
% Return values:
%  lbe: Array of edges lengths, 1-by-nbe array (double). lbe(j) is
%       the length of the j-th edge.
%
% OptFEM2DP1 [V1.0e] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
  lbe=sqrt(sum((q(:,be(1,:)) - q(:,be(2,:))).^2,1));
