function AElem=ElemStiffMatP1(q1,q2,q3,area)
% function AElem=ElemStiffMatP1(q1,q2,q3,area)
%   Computation of the element stiffness matrix for
%   P1-Lagrange finite elements
%
% Parameters:
%  q1: Coordinates of the first vertex in the triangle,  2-by-1 array (double) 
%  q2: Coordinates of the second vertex in the triangle, 2-by-1 array (double) 
%  q3: Coordinates of the third vertex in the triangle,	 2-by-1 array (double) 
%  area: triangle area (double)
%
% Return values:
%  AElem: Element stiffness matrix, 3-by-3 matrix (double).
%
% Example: 
%    q1=[0;0];q2=[0;1];q3=[1;0];
%    area=1/2.;
%    AElem=ElemStiffMatP1(q1,q2,q3,area);
%
% OptFEM2DP1 [V1.0e] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
M=[q2-q3, q3-q1, q1-q2];
AElem=(1/(4*area))*M'*M;
