function runValids(varargin)
% function runValids(varargin)
%   Run validation tests for Mass, MassW and Stiff matrices.
%
% Parameters:
%   save    :  set to true to save figures in image directory.
%   percent :  value for resizing the figure (only png format). 
%              See SaveFigure function for details.
%
% Usages:
%  - runValids()
%  - runValids('save',true)
%  - runValids('save',true,'percent',75)
%
% See also:
%   validMassP1, validMassWP1, validStiffP1, SaveFigure
%
% OptFEM2DP1 [V1.0e] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
InitOptFEM2D();

p = inputParser; 
  
if isOctave()
  p=p.addParamValue('save', false, @islogical );
  p=p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
  p=p.parse(varargin{:});
else % Matlab
  p.addParamValue('save', false, @islogical );
  p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
  p.parse(varargin{:});
end
close all

figure(1)
validMassP1();
SaveFigure(p.Results.save,'validMassP1',p.Results.percent)
figure(2)
validMassWP1();
SaveFigure(p.Results.save,'validMassWP1',p.Results.percent)
figure(3)
validStiffP1();
SaveFigure(p.Results.save,'validStiffP1',p.Results.percent)
