function AElem=ElemMassWMatP1(area,w)
% function AElem=ElemMassWMatP1(area,w)
%   Computation of the element weighted mass matrix for
%   P1-Lagrange finite elements
%   
% Parameters:
%  area: triangle area (double).
%  w: values of the weight function at the triangle vertices,
%  3-by-1 array (double).
%  
% Return values:
%  AElem: Element weighted mass matrix, 3-by-3 matrix (double).
%
% Example:
%    area=1/2.;
%    w=ones(3,1);
%    AElem=ElemMassWMatP1(area);
%
% OptFEM2DP1 [V1.0e] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
  AElem=(area/30)*[ 3*w(1)+w(2)+w(3), w(1)+w(2)+w(3)/2, w(1)+w(2)/2+w(3); ...
                    w(1)+w(2)+w(3)/2, w(1)+3*w(2)+w(3), w(1)/2+w(2)+w(3); ...
                    w(1)+w(2)/2+w(3), w(1)/2+w(2)+w(3), w(1)+w(2)+3*w(3)];
