function SaveFigure(issave,Name,percent)
% function SaveFigure(issave,Name,percent)
%   To manage the saving of figures. Save in eps, jpg and png format.
%   
% Parameters:
%  issave: boolean. If true saving figure is done.
%  Name: name of the destination file without extension (string)
%  percent: value for resizing the figure (only png format under unix)
%
%
% OptFEM2DP1 [V1.0e] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
if issave
  [SUCCESS,MESSAGE,MESSAGEID] = mkdir('images');
  eval(sprintf('print -depsc2 images/%s.eps',Name))
  fprintf(' -> save figure(%d) in images/%s.eps\n',gcf,Name);
  eval(sprintf('print -djpeg90 images/%s.jpg',Name))
  fprintf(' -> save figure(%d) in images/%s.jpg\n',gcf,Name);
  if isunix
    system(sprintf('convert -resize %d%% images/%s.eps images/%s.png',percent,Name,Name));
    fprintf(' -> save figure(%d) in images/%s.png (resize %d%%)\n',gcf,Name,percent);
  else
    eval(sprintf('print -dpng images/%s.png',Name))
    fprintf(' -> save figure(%d) in images/%s.png \n',gcf,Name);
  end
end
