function benchMassP1()
% function benchMassP1()
%   Benchmark function for MassAssembling `P_1` functions.
%
% See also:
%   #MassAssemblingP1base, #MassAssemblingP1OptV0, #MassAssemblingP1OptV1, #MassAssemblingP1OptV2
%
% OptFEM2DP1 [V1.1] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
  LN=[20:20:100];
  k=1;
  for N=LN  
    Th=SquareMesh(N);
    fprintf('---------------------------------------------------------\n')
    fprintf('BENCH (Mass Matrix Assembling) %d\n',k)
    fprintf(' Vertices number : %d - Triangles number : %d\n',Th.nq,Th.nme)
    fprintf(' Matrix size   : %d\n',Th.nq)
    tic();
    M=MassAssemblingP1base(Th.nq,Th.nme,Th.me,Th.areas);
    T(1)=toc();
    fprintf('    CPU times base (ref) : %3.4f (s)\n',T(1))
    tic();
    M=MassAssemblingP1OptV0(Th.nq,Th.nme,Th.me,Th.areas);
    T(2)=toc();
    fprintf('    CPU times OptV0      : %3.4f (s) - Speed Up X%3.3f\n',T(2),T(1)/T(2))
    tic();
    M=MassAssemblingP1OptV1(Th.nq,Th.nme,Th.me,Th.areas);
    T(3)=toc();
    fprintf('    CPU times OptV1      : %3.4f (s) - Speed Up X%3.3f\n',T(3),T(1)/T(3))
    tic();
    M=MassAssemblingP1OptV2(Th.nq,Th.nme,Th.me,Th.areas);
    T(4)=toc();
    fprintf('    CPU times OptV2      : %3.4f (s) - Speed Up X%3.3f\n',T(4),T(1)/T(4))
    k=k+1;
  end
