function Test=valid_FEMmatrices()
% Automatic computation of integrals with Sage
%
% This function is used in validation tests.
%
% OptFEM2DP1 [V1.1] -    Copyright (C) 2013  CJS (LAGA)
%
%   This file is part of OptFEM2DP1.
%   OptFEM2DP1 is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   OptFEM2DP1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>.
i=1;
Test(i).u=@(x,y) x + y;
Test(i).cu='x + y';
Test(i).v=@(x,y) x - y;
Test(i).cv='x - y';
Test(i).w=@(x,y) 2.*x + y;
Test(i).cw='2*x + y';
Test(i).Mass=0.0000000000000000;
Test(i).MassW=0.08333333333333333;
Test(i).Stiff=0.0000000000000000;
Test(i).degree=1;
i=2;
Test(i).u=@(x,y) 3.*x + 2.*y - 1;
Test(i).cu='3*x + 2*y - 1';
Test(i).v=@(x,y) 2.*x - 2.*y + 1;
Test(i).cv='2*x - 2*y + 1';
Test(i).w=@(x,y) 2.*x - 5.*y;
Test(i).cw='2*x - 5*y';
Test(i).Mass=1.666666666666667;
Test(i).MassW=-1.083333333333333;
Test(i).Stiff=2.000000000000000;
Test(i).degree=1;
i=3;
Test(i).u=@(x,y) 3.*x.^2 - x.*y + 2.*y.^2;
Test(i).cu='3*x^2 - x*y + 2*y^2';
Test(i).v=@(x,y) 2.*x.^2 + x.*y - 3.*y.^2 - y;
Test(i).cv='2*x^2 + x*y - 3*y^2 - y';
Test(i).w=@(x,y) x.*y;
Test(i).cw='x*y';
Test(i).Mass=-0.7500000000000000;
Test(i).MassW=-0.3416666666666667;
Test(i).Stiff=0.8333333333333333;
Test(i).degree=2;
i=4;
Test(i).u=@(x,y) 3.*x.^2 - 4.*x.*y + 2.*y.^2 - x + 4.*y + 4;
Test(i).cu='3*x^2 - 4*x*y + 2*y^2 - x + 4*y + 4';
Test(i).v=@(x,y) 2.*x.^2 + 2.*x.*y - 3.*y.^2 - 2.*y + 1;
Test(i).cv='2*x^2 + 2*x*y - 3*y^2 - 2*y + 1';
Test(i).w=@(x,y) x.^2 + y.^2 - 3;
Test(i).cw='x^2 + y^2 - 3';
Test(i).Mass=-0.3611111111111111;
Test(i).MassW=0.2805555555555556;
Test(i).Stiff=-17.33333333333333;
Test(i).degree=2;
i=5;
Test(i).u=@(x,y) 3.*x.^3 - 2.*x.*y + 2.*y.^2 + 3.*x;
Test(i).cu='3*x^3 - 2*x*y + 2*y^2 + 3*x';
Test(i).v=@(x,y) -3.*y.^3 + 2.*x.^2 + 2.*x.*y - 2.*y;
Test(i).cv='-3*y^3 + 2*x^2 + 2*x*y - 2*y';
Test(i).w=@(x,y) x.^2.*y + x.*y.^2 - 2.*x.*y + 1;
Test(i).cw='x^2*y + x*y^2 - 2*x*y + 1';
Test(i).Mass=-0.5708333333333333;
Test(i).MassW=-0.4377380952380952;
Test(i).Stiff=10.33333333333333;
Test(i).degree=3;
i=6;
Test(i).u=@(x,y) 3.*x.^4 + 3.*x.^3 + 2.*y.^2;
Test(i).cu='3*x^4 + 3*x^3 + 2*y^2';
Test(i).v=@(x,y) 2.*y.^4 - 3.*y.^3 + 2.*x.^2;
Test(i).cv='2*y^4 - 3*y^3 + 2*x^2';
Test(i).w=@(x,y) x.^4 + y.^3 - 3;
Test(i).cw='x^4 + y^3 - 3';
Test(i).Mass=1.400515873015873;
Test(i).MassW=-3.020477994227994;
Test(i).Stiff=16.00000000000000;
Test(i).degree=4;
i=7;
Test(i).u=@(x,y) x.^5 + 3.*x.^3.*y.^2 - y.^5;
Test(i).cu='x^5 + 3*x^3*y^2 - y^5';
Test(i).v=@(x,y) 3.*x.^5 + 2.*x.^3.*y.^2 + 2.*y.^5 + 2.*x.^2.*y.^2;
Test(i).cv='3*x^5 + 2*x^3*y^2 + 2*y^5 + 2*x^2*y^2';
Test(i).w=@(x,y) -3.*x.^3.*y.^2 + x.^2 + y.^2 + 1;
Test(i).cw='-3*x^3*y^2 + x^2 + y^2 + 1';
Test(i).Mass=0.9669672919672920;
Test(i).MassW=1.011666243809101;
Test(i).Stiff=18.73777777777778;
Test(i).degree=5;
i=8;
Test(i).u=@(x,y) x.^6 - x.^5 + 3.*x.^3.*y.^2 - y.^5;
Test(i).cu='x^6 - x^5 + 3*x^3*y^2 - y^5';
Test(i).v=@(x,y) y.^6 + 3.*x.^5 + 2.*x.^3.*y.^2 + 2.*y.^5 + 2.*x.^2.*y.^2;
Test(i).cv='y^6 + 3*x^5 + 2*x^3*y^2 + 2*y^5 + 2*x^2*y^2';
Test(i).w=@(x,y) 4.*x.^6 - 3.*x.^3.*y.^3 - y.^6;
Test(i).cw='4*x^6 - 3*x^3*y^3 - y^6';
Test(i).Mass=0.4305452484023913;
Test(i).MassW=0.5553725794902266;
Test(i).Stiff=6.920317460317460;
Test(i).degree=6;
