function runValids(varargin)
% function runValids(varargin)
%   Run validation tests for Mass, MassW, Stiff and StiffElas matrices.
%
% Parameters:
%   save    :  set to true to save figures in image directory.
%   percent :  value for resizing the figure (only png format). 
%              See SaveFigure function for details.
%
% Examples:
%  - runValids()
%  - runValids('save',true)
%  - runValids('save',true,'percent',75)
%
% See also:
%   validMassP1, validMassWP1, validStiffP1, validStiffElasP1, SaveFigure
%
% Copyright (C) 2013  CJS (LAGA)
%   see README for details
InitOptFEM2D();

p = inputParser; 
  
if isOctave()
  p=p.addParamValue('save', false, @islogical );
  p=p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
  p=p.parse(varargin{:});
else % Matlab
  p.addParamValue('save', false, @islogical );
  p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
  p.parse(varargin{:});
end
close all

figure(1)
validMassP1();
SaveFigure(p.Results.save,'validMassP1',p.Results.percent)
figure(2)
validMassWP1();
SaveFigure(p.Results.save,'validMassWP1',p.Results.percent)
figure(3)
validStiffP1();
SaveFigure(p.Results.save,'validStiffP1',p.Results.percent)
figure(4)
validStiffElasP1(0);
SaveFigure(p.Results.save,'validStiffElasP1',p.Results.percent)
