function LoM_demo1(varargin)
% function LoM_demo1
%   demo function using plot commands on List of Meshes.
%   Before first use, generate FreeFEM++ meshes : in 'mesh' directory 
%   - under Matlab 
%     @verbatim !make Ring3x3_C @endverbatim
%   - under Linux shell
%     @verbatim make Ring3x3_C @endverbatim
%     
% Parameters:
%   save    :  set to true to save figures in image directory.
%   percent :  set png image resize percent
%   basename : set basename mesh fileses
%   labeldom : list of label domains
%   refine   : indice of refinement
%
% See also:
%   FreeFEM++ edp files and Makefile in 'mesh' directory
%
% Examples:
%  - @verbatim 
%    LoM_demo1()@endverbatim
%    \image html images/MultiPlotMesh_Ring3x3_C.png "figure : LoM_demo1() meshes plot"
%    \image html images/MultiPlotBounds_Ring3x3_C.png "figure : LoM_demo1() boundaries plot"
%  - @verbatim 
%    LoM_demo1('basename','RectTroue12_C','labeldom',0:11,'refine',randi(5,1,12))@endverbatim
%    \image html images/MultiPlotMesh_RectTroue12_C.png "figure : \'RectTroue12_C\' meshes plot"
%    \image html images/MultiPlotBounds_RectTroue12_C.png "figure : \'RectTroue12_C\' boundaries plot"
%  - @verbatim
%    LoM_demo1('basename','RectTroue12_NC','labeldom',0:11,'refine',randi(5,1,12))@endverbatim
%    \image html images/MultiPlotMesh_RectTroue12_NC.png "figure : \'RectTroue12_NC\' meshes plot"
%    \image html images/MultiPlotBounds_RectTroue12_NC.png "figure : \'RectTroue12_NC\' boundaries plot"
p = inputParser; 
%  
p.addParamValue('save', false, @islogical );
p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
p.addParamValue('basename','Ring3x3_C', @isstr );
p.addParamValue('labeldom',0:8, @isnumeric );
p.addParamValue('refine',2,@isnumeric);
p.parse(varargin{:});

close all

addpath('base')
addpath('graphic')

if length(p.Results.refine)==1
  a=p.Results.refine*ones(1,length(p.Results.labeldom));
else
  a=p.Results.refine;
end
DirName=['mesh',filesep,p.Results.basename,filesep];
for k=1:length(p.Results.labeldom)
  FileMesh=sprintf('%s%s%d_%d.msh',DirName,p.Results.basename,p.Results.labeldom(k),a(k));
  LoM(k)=GetMeshOpt(FileMesh);
end

figure(1)
MultiPlotMesh(LoM,'colormap','jet','Label',true);
SaveImage(p.Results.save,['MultiPlotMesh_',p.Results.basename],p.Results.percent)

figure(2)
MultiPlotBounds(LoM,'colormap','HSV','Label',true);
SaveImage(p.Results.save,['MultiPlotBounds_',p.Results.basename],p.Results.percent)

