function Mesh=GetMeshOpt(cFileName)
% function Mesh=GetMeshOpt(cFileName)
%   Initialization of the Mesh structure from a FreeFEM++ mesh file
%
% Parameters:
%  cFileName: file name (string)
%
% Return values:
%  Mesh: mesh structure (see report)
%
% Generated fields of Mesh:
%  q: 
%  me:
%
% Usage:  Th=GetMesh('carre.msh')
  [fid,message]=fopen(cFileName,'r');
  if ( fid == -1 )
    error([message,' : ',cFileName]);
  end
  if isOctave()
  [n]=fscanf(fid,'%d %d %d',3);

  R=fscanf(fid,'%f %f %d',[3,n(1)]);
  q=R([1 2],:);
  ql=R(3,:);
  R=fscanf(fid,'%d %d %d %d',[4,n(2)]);

  me=R([1:3],:);
  mel=R(4,:);
  R=fscanf(fid,'%d %d %d',[3,n(3)]);
  
  be=R([1 2],:);
  bel=R(3,:);
  else % Matlab
  n=textscan(fid,'%d %d %d',1); % n(1) -> number of vertices
		      % n(2) -> number of triangles
		      % n(3) -> number of boundary edges
  
  R=textscan(fid,'%f %f %d',n{1});
  q=[R{1},R{2}]';
  ql=R{3}';
  R=textscan(fid,'%d %d %d %d',n{2});
  me=[R{1},R{2},R{3}]';
  mel=R{4}';

  R=textscan(fid,'%d %d %d',n{3});
  be=[R{1},R{2}]';
  bel=R{3}';
  end
  fclose(fid);

  Mesh=struct('q',q,'me',me,'ql',ql,'mel',mel,'be',be,'bel',bel, ...
            'nq',size(q,2), ...
            'nme',size(me,2), ...
            'nbe',size(be,2), ...
            'areas',ComputeAreaOpt(q,me),...
            'lbe',EdgeLengthOpt(be,q));

