function [e2q,e2t,e2n,e2do,e2be]=BuildEdges(Th)
% e2q  (nedx2) Edges to Nodes 
%   e2q(l,il) : indice dans le tableau Th.q du sommet il de l'arete l
% e2t  (nedx2) Edges to Triangles
%   e2t(l,1) : indice dans le tableau Th.me du 1er triangle adjacent 
%              a l'arete l 
%   e2t(l,2) : indice dans le tableau Th.me du 2eme triangle adjacent 
%              a l'arete l si arete interne sinon 0
% e2n (nedx2) : Edges to local number 
%   e2n(l,1)  : numero local de l'arete dans le 1er triangle (voir e2t)
%   e2n(l,2)  : numero local de l'arete dans le 2eme triangle (voir e2t)
%               s'il existe. 0 sinon.
% e2do (nedx1) 
%   e2do(l)   : +1 si l'arete est dans le sens direct pour le 1er triangle (voir e2t)
%               -1 sinon
% e2be (nbex3) : nbe number of boundary edges
%   e2be(l,1)  : numero de l'arete du bord 
%   e2be(l,2)  : +1 si l'arete est dans le "bon" sens
%                -1 sinon
%   e2be(l,3)  : label du bord
NumLocEdges=[ 1 2 ;2 3; 3 1]; % Numerotation locale des aretes 
                              % 
%NumLocEdges=[ 2 3 ;3 1; 1 2];

GlobalListEdges=[reshape(Th.me(NumLocEdges(:,1),:),3*Th.nme,1),reshape(Th.me(NumLocEdges(:,2),:),3*Th.nme,1)];

Edges2Elements=ones(3,1)*[1:Th.nme];
Edges2Elements=Edges2Elements(:);

Edges2LocalNum=[1; 2 ;3]*ones(1,Th.nme);
Edges2LocalNum=Edges2LocalNum(:);

[GlobalListEdgesSort,IS]=sort(GlobalListEdges,2);
PermutEdges=IS(:,2)-IS(:,1); % Contient 1 si arete dans le sens direct pour le triangle considéré
                             % Contient -1 sinon
                             
[e2q,IG,IE]=unique(GlobalListEdgesSort,'rows','first');   
e2t=Edges2Elements(IG,:);
e2n=Edges2LocalNum(IG,:);
e2do=PermutEdges(IG); % 

[e2ql,IGl,IEf]=unique(GlobalListEdgesSort,'rows','last');
e2tl=Edges2Elements(IGl,:);
e2nl=Edges2LocalNum(IGl,:);
Id=find(IG==IGl);
e2tl(Id)=0;
e2nl(Id)=0;
e2t=[e2t e2tl];
e2n=[e2n e2nl];

if nargout==5
  I=find(e2t(:,2)==0);
  BE=Th.be';
  [BE0,L]=sort(BE(:,2));
  BE0=BE(L,:);
  [BE1,J]=sort(BE0,2); % I(
  %BE1=[BE1 Th.bel'];
  [BE2a,K]=sort(BE1(:,1));
  BE1=[BE1 Th.bel(L)'];
  BE2=BE1(K,:);
  JJ=J(K,1)-J(K,2);
  TT=[BE2 JJ];
  TTT=sortrows(TT,[1 2]);
% Ici on doit avoir
%   e2q(I,:) == TTT(:,1:2)
%   
  e2be=[I TTT(:,4) TTT(:,3)];
  %[BE(K,:), e2q(I,:) Th.bel(K)']
end