function [RefTh,MatProj]=RefineMesh(varargin)
% function [RefTh,MatProj]=RefineThOptV1(varargin)
%   refines the mesh Th by a factor of 4
%
% parameters:
%   Th :  mesh structure
%   sort : set to true if sort boundaries
%
% Example:
%  - Original mesh (Th)
%  \image html images/RefineMesh1.png "figure : Mesh before refinement" 
%  \image latex images/RefineMesh1.eps "My application" width=10cm
%  - Refine mesh (Thr1)
%  @verbatim 
%   Thr1=RefineMesh(Th); @endverbatim
%  \image html images/RefineMesh2.png "figure : Mesh after refinement : sort=false"
%  - Refine mesh with sort boundaries (Thr2) 
%  @verbatim 
%   Thr2=RefineMesh(Th,'sort',true); @endverbatim
%  \image html images/RefineMesh3.png "figure : Mesh after refinement : sort=true"
%
  p = inputParser; 
  p.addRequired('Th', @isstruct);
%  
  p.addParamValue('sort', false, @islogical );

  p.parse(varargin{:});
  Th=p.Results.Th;

  [e2q,e2t,e2n,e2do,e2be]=BuildEdges(Th);
  [qf,mef]=BuildMeshP2(Th,e2q,e2t,e2n);

  [beref,belref]=BuildBE(e2q,e2be,Th.nq);
  beref=beref';
  belref=belref';
  Tr=[mef([1 2 4],:),mef([2 3 5],:),mef([2 5 4],:),mef([4 5 6],:)];
  mel=[Th.mel,Th.mel,Th.mel,Th.mel];
  qfl=zeros(1,size(qf,2));
  qfl=zeros(1,size(qf,2));
  qfl(1:Th.nq)=Th.ql;
  titi=zeros(1,size(e2q,1));
  titi(e2be(:,1))=e2be(:,3);
  qfl(Th.nq+1:end)=titi; 
  
  if nargout==2
    MatProj=GetMatPrTh2RefTh(Th.nq,e2q);
  end
  if p.Results.sort
    [beref,belref]=SortBoundary(beref,belref);
  end
  RefTh=struct('q',qf,'me',Tr,'ql',qfl,'mel',mel,'be',beref,'bel',belref, ...
            'nq',size(qf,2), ...
            'nme',size(Tr,2), ...
            'nbe',size(beref,2), ...
            'areas',ComputeAreaOpt(qf,Tr),...
            'lbe',EdgeLengthOpt(beref,qf));             
end
