function refine_demo1(varargin)
% function refine_demo1(varargin)
%   demo function using refine mesh tools and mesh plot command.
%   
% Parameters:
%   save    :  set to true to save figures in image directory.
%   savename :  set save file base name.
%   percent :  set color mesh lines
%   meshfile : set mesh file name
%   randlabel : if true, boundaries label set to random values
%
% Examples:
%  - Original mesh (Th)
%  \image html images/RefineMesh1.png "figure : Mesh before refinement" 
%  \image latex images/RefineMesh1.eps "My application" width=10cm
%  - Refine mesh (Thr1)
%  @verbatim 
%   Thr1=RefineMesh(Th); @endverbatim
%  \image html images/RefineMesh2.png "figure : Mesh after refinement : sort=false"
%  - Refine mesh with sort boundaries (Thr2) 
%  @verbatim 
%   Thr2=RefineMesh(Th,'sort',true); @endverbatim
%  \image html images/RefineMesh3.png "figure : Mesh after refinement : sort=true"
%
% See also:
%  #RefineMesh
p = inputParser; 
%  
p.addParamValue('save', false, @islogical );
p.addParamValue('savename', 'RefineMesh', @isstr );
p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
p.addParamValue('meshfile',['mesh',filesep,'disque4-1-3.msh'], @isstr );
p.addParamValue('randlabel',false,@islogical);
p.parse(varargin{:});
close all

addpath('base');
addpath('graphic');
addpath('refine');

Th=GetMeshOpt(p.Results.meshfile);
%%%%%%%
% give random boundaries label 
if p.Results.randlabel
  LB=unique(Th.bel);
  nB=length(LB);
  belT=Th.bel*0;
  for i=1:nB
    I=find(Th.bel == LB(i));
    belT(I)=randi(1000);
  end
  Th.bel=belT;
end
%%%%%%%

figure(1)
PlotMesh(Th,'color',[0 0 0])
RGBcolors=PlotBounds(Th,'LineWidth',2);
PlotBoundsEdgeNumber(Th,'RGBEdgeColors',RGBcolors,'Color',[0 0 0],'LineStyle','-','LineWidth',0.5);
SaveImage(p.Results.save,[p.Results.savename,'1'],p.Results.percent)
title('Mesh before refinement')

Thref=RefineMesh(Th);
figure(2)
PlotMesh(Thref,'color',[0 0 0])
PlotBounds(Thref,'LineWidth',2,'RGBcolors',RGBcolors);
PlotBoundsEdgeNumber(Thref,'RGBEdgeColors',RGBcolors,'Color',[0 0 0],'LineStyle','-','LineWidth',0.5);
SaveImage(p.Results.save,[p.Results.savename,'2'],p.Results.percent)
title('Mesh after refinement : sort=false')

Threfs=RefineMesh(Th,'sort',true);
figure(3)
PlotMesh(Threfs,'color',[0 0 0])
PlotBounds(Threfs,'LineWidth',2,'RGBcolors',RGBcolors);
PlotBoundsEdgeNumber(Threfs,'RGBEdgeColors',RGBcolors,'Color',[0 0 0],'LineStyle','-','LineWidth',0.5);
SaveImage(p.Results.save,[p.Results.savename,'3'],p.Results.percent)
title('Mesh after refinement : sort=true')