function area=ComputeAreaOpt(q,me)
% function area=ComputeAreaOpt(q,me)
%   Compute areas of triangles mesh
%
% Parameters:
%  'q': `2\times\nq` array, `{\q}(\il,j)` is the  `\il`-th coordinate of the `j`-th vertex, `\il\in\{1,2\}` and `j\in\{1,\hdots,n_q\}.`
%       Also noted `\q`.
%  me: `3\times\nme` 'int32' array,`\me(\jl,k)` index of storage, in the array `\q`, of the `\jl`-th
%       vertex of the triangle of index `k`, `\jl\in\{1,2,3\}` and `k\in\{1,\hdots,\nme\}.`
%       Also noted `\me`.
%
% Return values:
%  areas: `1\times\nme` array, areas(k) is the area of triangle k.
c1 = q(:,me(1,:));
d21 = q(:,me(2,:))-c1;
d31 = q(:,me(3,:))-c1;
area = 0.5*(d21(1,:).*d31(2,:)-d21(2,:).*d31(1,:));