function lbe=EdgeLengthOpt(be,q)
% function lbe=EdgeLengthOpt(be,q)
%   Compute length of boundary edges
%
% Parameters:
%  be: `2\times\nbe` 'int32' array,`\be(\jl,k)` index of storage, in the array `\q`, of the `\jl`-th
%       vertex of the edge of index `k`, `\jl\in\{1,2\}` and `k\in\{1,\hdots,\nbe\}.`
%       Also noted `\be`.
%  'q': `2\times\nq` array, `{\q}(\il,j)` is the  `\il`-th coordinate of the `j`-th vertex, `\il\in\{1,2\}` and `j\in\{1,\hdots,n_q\}.`
%       Also noted `\q`.
%
% Return values:
%  lbe: `1\times\nbe` array, lbe(k) is the length of edge k.
lbe=sqrt(sum((q(:,be(1,:)) - q(:,be(2,:))).^2,1));
