function RGBcolors=MultiPlotBounds(varargin)
% function RGBcolors=MultiPlotBounds(varargin)
%   Plot boundaries of list of meshes
% 
% parameters:
%   LoM : array of Meshes
%   colormap : value can be \'Jet\', \'HSV\', \'Gray\', \'colorcube\',\'Cool\',\'Spring\',\'Summer\',...
%   RGBcolors : 
%   BoundLineWidth : set boundaries lines width
%   LabelLineWidth : set box label lines width
%   FontSize : set font size value
%   Label : set label visible, true or false
%
% Example:
%  @verbatim 
%   MultiPlotBounds(LoM,'colormap','jet','Label',true) @endverbatim
%  \image html images/MultiPlotBounds_Ring3x3_C.png "figure : MultiPlotBounds(LoM,\'colormap\',\'jet\',\'Label\',true)"
%
% See also :
%   #LoM_demo1
p = inputParser; 
p.addRequired('LoM', @isstruct);
%  
p.addParamValue('colormap', 'Jet', @isstr );
p.addParamValue('RGBcolors', [], @isnumeric );
p.addParamValue('BoundLineWidth', 1.0 , @isnumeric );
p.addParamValue('LabelLineWidth', 2.0 , @isnumeric );
p.addParamValue('FontSize', 12 , @isnumeric );
p.addParamValue('Label', false , @islogical );
p.parse(varargin{:});

LoM=p.Results.LoM;
nM=length(LoM);
NumBound=unique(cat(2,LoM(:).bel));
nNB=length(NumBound);

hold on
cmap=colormap(p.Results.colormap);% colorcube ou Lines
 
t=0:1/(nNB-1):1;
if (isempty(p.Results.RGBcolors))
  RGBcolors=RGB(t,cmap);
else
  RGBcolors=p.Results.RGBcolors;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Représentation des bords %%%%
boolNB=zeros(1,nNB);
for M=LoM % Boucle sur les maillages
  NBoM=unique(M.bel);
  for i=1:length(NBoM) % Boucle sur les numéros de bord
    I=find(M.bel == NBoM(i));
    icolor=find( NumBound == NBoM(i));
    if ~isempty(I)
      for j=I
        h=plot([M.q(1,M.be(1,j)) M.q(1,M.be(2,j))], ...
               [M.q(2,M.be(1,j)) M.q(2,M.be(2,j))]);
        set(h,'Color',RGBcolors(icolor,:),'LineWidth',p.Results.BoundLineWidth);
      end
    end
  end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Numéro des bords %%%%
if p.Results.Label
  boolNB=zeros(1,nNB);
  for M=LoM % Boucle sur les maillages
    NBoM=unique(M.bel);
    for i=1:length(NBoM) % Boucle sur les numéros de bord
      I=find(M.bel == NBoM(i));
      icolor=find( NumBound == NBoM(i));
      if ~isempty(I)
        if (~boolNB(icolor))
          boolNB(icolor)=1;
          ip=I(round(length(I)/2));
          Pmx=(M.q(:,M.be(1,ip))+M.q(:,M.be(2,ip)))/2;
          h=text(Pmx(1),Pmx(2),['\Gamma_{',num2str(NBoM(i)),'}']);
          set(h,'FontSize',p.Results.FontSize,'Color','k', ...
                'BackgroundColor','w','LineWidth',p.Results.LabelLineWidth, ...
                'EdgeColor',RGBcolors(icolor,:),'FontWeight','bold');
        end
      end
    end
  end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
hold off
axis off
axis equal
