function RGBcolors=MultiPlotMesh(varargin)
% function RGBcolors=MultiPlotMesh(varargin)
%   Plot List of Meshes 
%
% Parameters:
%   LoM : array of Meshes
%   RGBcolors : set boundaries colors
%   colormap : set colormap value to \'Jet\', \'HSV\', \'Gray\', \'colorcube\',\'Cool\',\'Spring\',\'Summer\',...
%   Legend : set legend visible at true or false
%   MeshLineWidth : set mesh lines width
%   LabelLineWidth : set label box lines width
%   FontSize : set label font size
%   Label : set mesh label visible, true or false
%
% Example:
%  @verbatim 
%   MultiPlotMesh(LoM,'colormap','jet','Label',true) @endverbatim
%  \image html images/MultiPlotMesh_Ring3x3_C.png "figure : MultiPlotMesh(LoM,\'colormap\',\'jet\',\'Label\',true)"
%
% See also :
%   #LoM_demo1
p = inputParser; 
p.addRequired('LoM', @isstruct);
%  
p.addParamValue('colormap', 'HSV', @isstr );
p.addParamValue('RGBcolors', [], @isnumeric );
p.addParamValue('MeshLineWidth', 0.5 , @isnumeric );
p.addParamValue('LabelLineWidth', 2.0 , @isnumeric );
p.addParamValue('FontSize', 12 , @isnumeric );
p.addParamValue('Label', false , @islogical );
p.parse(varargin{:});
LoM=p.Results.LoM;

nM=length(LoM);
NumBound=unique(cat(2,LoM(:).bel));
nNB=length(NumBound);

cmap=colormap(p.Results.colormap);% colorcube ou Lines Jet HSV

t=0:1/(nM-1):1;t=t*0.8;
if (isempty(p.Results.RGBcolors))
  RGBcolors=RGB(t(randperm(nM)),cmap);
else
  RGBcolors=p.Results.RGBcolors;
end


IH=ishold;
if (~IH) 
  hold on
end
for i=1:nM % Boucle sur les maillages
  h=triplot(LoM(i).me',LoM(i).q(1,:),LoM(i).q(2,:),'LineWidth',p.Results.MeshLineWidth);%,'color',RGB(t(i),cmap));
  set(h,'color',RGBcolors(i,:));
end
if p.Results.Label
  for i=1:nM % Boucle sur les maillages
    I=find(LoM(i).ql == 0);
    ip=round(length(I)/2);
    h=text(LoM(i).q(1,I(ip)),LoM(i).q(2,I(ip)),['\Omega_{',num2str(i-1),'}']);
    set(h,'FontSize',p.Results.FontSize,'Color','k','BackgroundColor','w', 'LineWidth',p.Results.LabelLineWidth,...
          'EdgeColor',RGBcolors(i,:),'FontWeight','bold');
  end
end

if (~IH) 
  hold off
end
axis equal
axis off
