function graphic_demo1(varargin)
% function graphic_demo1
%   code using basic mesh plot command.
% 
% Parameters:
%   save    :  set to true to save figures in image directory.
%   percent :  set color mesh lines
%   meshfile : set mesh file name
%
% Examples:
%   @verbatim graphic_demo1('save',true,'percent',30)@endverbatim
%   \image html images/PlotMesh.png "figure(1) : PlotMesh(Th,\'Color\',[1 0 0],\'LineWidth\',1);"
%   \image html images/PlotBounds.png "figure(2) : PlotBounds(Th,\'LineWidth\',2);"
%   \image html images/PlotBoundsAndMesh.png "figure(3) : PlotMesh and PlotBounds"
%   \image html images/PlotVal.png "figure(4) : PlotVal(Th,u,\'colormap\',\'Cool\');"
%
% See also:
%  #PlotMesh, #PlotBounds, #PlotVal
p = inputParser; 
%  
p.addParamValue('save', false, @islogical );
p.addParamValue('percent', 50 , @(t) ((t>0)&&(t<=100)) );
p.addParamValue('meshfile',['mesh',filesep,'disque4-1-10.msh'], @isstr );
p.parse(varargin{:});

close all

addpath('base');
addpath('graphic');
Th=GetMeshOpt(p.Results.meshfile);

figure(1)
PlotMesh(Th,'Color',[1 0 0],'LineWidth',1);
SaveImage(p.Results.save,'PlotMesh',p.Results.percent)
title(['Filename : ',p.Results.meshfile])


figure(2)
RGBcolors=PlotBounds(Th,'LineWidth',2);
SaveImage(p.Results.save,'PlotBounds',p.Results.percent)
title('Representation des frontieres du domaine')

figure(3)
PlotMesh(Th,'Color',[0 0 0]);
PlotBounds(Th,'colormap','spring','LineWidth',2,'RGBcolors',RGBcolors);
SaveImage(p.Results.save,'PlotBoundsAndMesh',p.Results.percent)
title('Representation du domaine et de ses frontieres')


% Representation d'une <fonction> sur un maillage
x=Th.q(1,:);y=Th.q(2,:);
k=pi;
u=cos(k*(x.^2+y.^2));

figure(4)
PlotVal(Th,u,'colormap','Cool');
SaveImage(p.Results.save,'PlotVal',p.Results.percent)

title('Representation de la fonction cos(pi*(x*x+y*y))')
axis off

figure(5)
[colors,values]=PlotIso(Th.q,Th.me,Th.be,u,15);
colorbarIso(colors,values)
axis off
title('Iso valeurs de la fonction cos(pi*(x*x+y*y))')


figure(6)
trisurf(Th.me',Th.q(1,:),Th.q(2,:),u)
%colormap('cool')
colorbar
shading interp
