function RGBcolors=PlotBounds(varargin)
% function RGBcolors=PlotBounds(varargin)
%   Plot mesh boundaries
%
% parameters:
%   Th  : mesh structure
%   RGBcolors : set boundaries colors
%   colormap : set colormap value to \'Jet\', \'HSV\', \'Gray\', \'colorcube\',\'Cool\',\'Spring\',\'Summer\',...
%   Legend : set legend visible at true or false
%   FontSize : set legend font size
%   LineWidth : set boundaries lines width
%
% Example:
%  @verbatim 
%   PlotBounds(Th,'LineWidth',2);@endverbatim
%  \image html images/PlotBounds.png "figure : PlotBounds(Th,\'LineWidth\',2);" 
p = inputParser; 
if isOctave()
  p=p.addRequired('Th', @isstruct);
%  
  p=p.addParamValue('colormap', 'jet', @ischar );
  p=p.addParamValue('RGBcolors', [], @isnumeric );
  p=p.addParamValue('LineWidth', 2.0 , @isnumeric );
  p=p.addParamValue('Legend', true , @islogical );
  p=p.addParamValue('FontSize', 10 , @isnumeric );
  p=p.parse(varargin{:});
else
  p.addRequired('Th', @isstruct);
  %  
  p.addParamValue('colormap', 'Jet', @ischar );
  p.addParamValue('RGBcolors', [], @isnumeric );
  p.addParamValue('LineWidth', 2.0 , @isnumeric );
  p.addParamValue('Legend', true , @islogical );
  p.addParamValue('FontSize', 10 , @isnumeric );
  p.parse(varargin{:});
end

Th=p.Results.Th;

stringMat=[];
LB=unique(Th.bel);
amax=length(LB);
cmap=colormap(p.Results.colormap);
if amax ==1
  t=0;
else
  t=0:1/(amax-1):1;
end
if (isempty(p.Results.RGBcolors))
  RGBcolors=RGB(t(randperm(amax)),cmap);
else
  RGBcolors=p.Results.RGBcolors;
end
PrevHold=SetHoldOn(true);
if p.Results.Legend
  cLegend='';
  for i=1:amax
    if i==amax
      cLegend=sprintf('%s''\\Gamma_{%d}''',cLegend,LB(i));
    else
      cLegend=sprintf('%s''\\Gamma_{%d}'',',cLegend,LB(i));
    end
  %stringMat=[stringMat ;'\Gamma_',num2str(LB(i))];
    I=find(Th.bel == LB(i));
    h(i)=plot([Th.q(1,Th.be(1,I(1))) Th.q(1,Th.be(2,I(1)))], ...
              [Th.q(2,Th.be(1,I(1))) Th.q(2,Th.be(2,I(1)))]);
    set(h(i),'Color',RGBcolors(i,:),'LineWidth',p.Results.LineWidth);
  end
  eval(sprintf('H=legend(h,%s);',cLegend));
  set(H,'FontSize',p.Results.FontSize);
end

% On trace enfin les bords
for i=1:amax
  I=find(Th.bel == LB(i));
  for k=I
    h=plot([Th.q(1,Th.be(1,k)) Th.q(1,Th.be(2,k))], ...
           [Th.q(2,Th.be(1,k)) Th.q(2,Th.be(2,k))]);
    set(h,'Color',RGBcolors(i,:),'LineWidth',p.Results.LineWidth);
  end
end
RestoreHold(PrevHold)
axis off
axis image