function vtkWriteMesh(Th,fid)
  if ischar(fid), fid=fopen(fid,'w');end
  fprintf(fid,'# vtk DataFile Version 2.0\n');
  fprintf(fid,'Generated Volume Mesh\n');
  fprintf(fid,'ASCII\n');
  fprintf(fid,'DATASET UNSTRUCTURED_GRID\n');
  fprintf(fid,'POINTS %d float\n',Th.nq);
  if Th.d==3
    for i=1:Th.nq
      fprintf(fid,'%g %g %g\n',Th.q(1,i),Th.q(2,i),Th.q(3,i));
    end

    fprintf(fid,'CELLS %d %d\n',Th.nme,5*Th.nme);
    for k=1:Th.nme
      fprintf(fid,'4 %d %d %d %d\n',Th.me(1,k)-1,Th.me(2,k)-1,Th.me(3,k)-1,Th.me(4,k)-1);
    end
    fprintf(fid,'CELL_TYPES %d\n',Th.nme);
    for k=1:Th.nme
      fprintf(fid,'10\n'); % 10 for tetrahedra
    end
  else
    if size(Th.q,1)==2
      for i=1:Th.nq
	fprintf(fid,'%g %g 0\n',Th.q(1,i),Th.q(2,i));
      end
    else
      for i=1:Th.nq
	fprintf(fid,'%g %g %g\n',Th.q(1,i),Th.q(2,i),Th.q(3,i));
      end
    end

    fprintf(fid,'CELLS %d %d\n',Th.nme,4*Th.nme);
    for k=1:Th.nme
      fprintf(fid,'3 %d %d %d \n',Th.me(1,k)-1,Th.me(2,k)-1,Th.me(3,k)-1);
    end
    fprintf(fid,'CELL_TYPES %d\n',Th.nme);
    for k=1:Th.nme
      fprintf(fid,'5\n'); % 5 for triangles
    end
  end
  fprintf(fid,'\n');