function  vtkWriteValues(FileName,Th,U,names)
  fid=fopen(FileName,'w');
  vtkWriteMesh(Th,fid);
  if ~isempty(U)
    fprintf(fid,'POINT_DATA %d\n',Th.nq);
    assert(iscell(U) & iscell(names));
    assert(length(U)==length(names));
    n=length(U);
    for i=1:n
      assert(size(U{i},1)==Th.nq);
      vtkWrite(fid,U{i},names{i});
    end
  end
  fclose(fid);
end

function vtkWrite(fid,U,name)
  assert(isnumeric(U));
  d=size(U,2);
  nq=size(U,1);
  assert(d<=3);
  if d==1
    fprintf(fid,'SCALARS %s float 1\n',name);
    fprintf(fid,'LOOKUP_TABLE table_%s\n',name);
    for i=1:nq
      fprintf(fid,'%g\n',U(i));
    end
  else
    X=zeros(nq,3);for i=1:d, X(:,i)=U(:,i);end
    fprintf(fid,'VECTORS vectors float\n');
    for i=1:nq
      fprintf(fid,'%g ',X(i,:));fprintf(fid,'\n');
    end
  end
  fprintf(fid,'\n');
end