from . import operators
from .FEMOptV3 import *
from .FEMtools import getVFindices

import numpy as np
from scipy import linalg
from scipy import sparse
import itertools
import types
from math import *
  
def  AssemblyP1(Th,Op,**kwargs):
  version=kwargs.get('version', 'OptV3') 
  gradient=kwargs.get('gradient', None) 
  Num=kwargs.get('Num',1)
  #dtype=kwargs.get('dtype',float)
  if operators.isoperatorL(Op):
    return globals()['DAssemblyP1_'+version](Th,Op,gradient)
  if operators.isoperatorH(Op):
    return globals()['HAssemblyP1_'+version](Th,Op,Num)


def NormH1(Th,U,**kwargs):
  Num=kwargs.get('Num', 1)
  m=len(U)//Th.nq  # division entiere
  if ( m*Th.nq != len(U) ):
    print('dimension error m=%d,nq=%d,len(U)=%d'%(m,Th.nq,len(U)))
  VFNum=getVFindices(Num,m,Th.nq)  
  OpM=operators.Dmass(Th.d,1.0)
  OpS=operators.Dstiff(Th.d)
  M=AssemblyP1(Th,OpM)
  K=AssemblyP1(Th,OpS)
  S=0.
  I=np.arange(Th.nq)
  for i in range(m):
    UI=U[VFNum(I,i)]
    S+=np.sqrt(np.dot(M*UI,UI)+np.dot(K*UI,UI))
  return S

def NormL2(Th,U):
  OpM=operators.Dmass(Th.d,1.0)
  M=AssemblyP1(Th,OpM)
  return np.sqrt(np.dot(M*U,U))