import matplotlib.pyplot as plt
import numpy as np
import sys,os
sep=os.path.sep
ToolBoxDir=os.path.abspath(os.path.dirname(os.path.abspath(__file__))+sep+"..")
sys.path.append(ToolBoxDir)

from pyVecFEMP1Light.mesh import readFreeFEM3D
from pyVecFEMP1Light.pde import solvePDE,initPDE,setBC_PDE
from pyVecFEMP1Light.FEMtools import setFdata,getVFindices
from pyVecFEMP1Light.operators import Loperator,Hoperator
from pyVecFEMP1Light.paraview import vtkWriteValues
from pyVecFEMP1Light.common import mkdir_p,run_from_ipython

MeshDir=ToolBoxDir+sep+'meshes'+sep+'3D'
Name='HeatAndFlowVelocity3d01'
MeshFile=MeshDir+sep+'FlowVelocity3d01-3.mesh'
VTKsaveDir=ToolBoxDir+sep+'vtk'

d=3
Num=1

print('1. Get mesh %s using pyVecFEMP1Light'%MeshFile)
Th=readFreeFEM3D(MeshFile)
print('  -> Mesh sizes : nq=%d, nme=%d, nbe=%d'%(Th.nq,Th.nme,Th.nbe));

print('2. Set 3D potential flow BVP. problem')
Hop=Hoperator(d=3,m=4)
Hop.H[0][1]=Loperator(d=d,b=[-1,0,0])
Hop.H[0][2]=Loperator(d=d,b=[0,-1,0])
Hop.H[0][3]=Loperator(d=d,b=[0,0,-1])
Hop.H[1][0]=Loperator(d=d,c=[-1,0,0])
Hop.H[1][1]=Loperator(d=d,a0=1)
Hop.H[2][0]=Loperator(d=d,c=[0,-1,0])
Hop.H[2][2]=Loperator(d=d,a0=1)
Hop.H[3][0]=Loperator(d=d,c=[0,0,-1])
Hop.H[3][3]=Loperator(d=d,a0=1)
PDEflow=initPDE(Hop,Th)

PDEflow=setBC_PDE(PDEflow,1020,0,'Dirichlet',-1)
PDEflow=setBC_PDE(PDEflow,1021,0,'Dirichlet',1)
PDEflow=setBC_PDE(PDEflow,2020,0,'Dirichlet',-1)
PDEflow=setBC_PDE(PDEflow,2021,0,'Dirichlet',1)

print('3. Solve 3D potential flow BVP problem')
W,info=solvePDE(PDEflow,Num=Num,split=True,verbose=True,SolveVersion='qmr',SolveOptions = {"x0": None, "tol": 1e-05, "maxiter":None})
print(info)
assert(info.residu < 1e-5);

print('4. Set 3D stationary heat BVP with potential flow')
af=1;
Lop=Loperator(d=Th.d,A=[[af,None,None],[None,af,None],[None,None,af]],c=[W[1],W[2],W[3]],a0=0.01);
pde=initPDE(Lop,Th)
pde=setBC_PDE(pde,1020,0,'Dirichlet',  30)
pde=setBC_PDE(pde,2020,0,'Dirichlet',  30)
pde=setBC_PDE(pde,10,0,'Dirichlet', lambda x,y,z: 10*(abs(z-1)>0.5))

print('5. Solve 3D stationary heat BVP with potential flow')
u,info=solvePDE(pde,SolveVersion='spLU',verbose=True)
print(info)

print('6. Save datas in vtk file')
mkdir_p(VTKsaveDir)
vtkFileName='%s%s%s.vtk'%(VTKsaveDir,sep,Name)
WW=np.zeros((Th.nq,3));WW[:,0]=W[1];WW[:,1]=W[2];WW[:,2]=W[3];
vtkWriteValues(vtkFileName,Th,[W[0],u,WW],['phi','u','V'])
print('  ->  save in file %s'%vtkFileName)
vtkFileName='%s%s%s-down.vtk'%(VTKsaveDir,sep,Name)
I=np.nonzero(pde.labels==1000)[0] 
vtkWriteValues(vtkFileName,pde.Bh[I],None,None)
print('  ->  save in file %s'%vtkFileName)
vtkFileName='%s%s%s-up.vtk'%(VTKsaveDir,sep,Name)
I=np.nonzero(pde.labels==2000)[0] 
vtkWriteValues(vtkFileName,pde.Bh[I],None,None)
print('  ->  save in file %s\n'%vtkFileName)
print('PARAVIEW visualization')
print(' -> To see results with ParaView (version >= 4.2.0)')
print('    From directory\n       %s\n    run system command :'%ToolBoxDir)
print('       paraview --state=vtk%s%s.pvsm'%(sep,Name))
