import matplotlib.pyplot as plt
import numpy as np
import sys,os
sep=os.path.sep
ToolBoxDir=os.path.abspath(os.path.dirname(os.path.abspath(__file__))+sep+"..")
sys.path.append(ToolBoxDir)

from pyVecFEMP1Light.mesh import HyperCube
from pyVecFEMP1Light.pde import initPDE,setBC_PDE,solvePDE
from pyVecFEMP1Light.operators import Loperator
from pyVecFEMP1Light.common import  run_from_ipython
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds

from math import pi,cos

plt.close("all")
d=2

print('1. Get mesh from HyperCube function')
trans=lambda q: np.c_[20*q[:,0],2*(2*q[:,1]-1+np.cos(2*pi*q[:,0]))]
Th=HyperCube(d,[100,20],trans=trans)
print('  -> Mesh sizes : nq=%d, nme=%d, nbe=%d'%(Th.nq,Th.nme,Th.nbe))

print('2. Set Poisson 2D problem')
pde=initPDE(Loperator(d=d,A=[[1,None],[None,1]]),Th)
pde=setBC_PDE(pde,1, 0,'Dirichlet', 0.,None)
pde=setBC_PDE(pde,2, 0,'Dirichlet', 1.,None)
pde=setBC_PDE(pde,3, 0,'Robin',-0.5,lambda x,y:1+x**2+y**2)
pde=setBC_PDE(pde,4, 0,'Neumann', 0.5,None)
pde.f=lambda x,y: cos(x+y) 

print('3. Solve Poisson 2D problem')
x=solvePDE(pde)

plt.ion() # interactive mode
plt.figure(1)
plt.clf()
plt.hold(True)
PlotMesh(Th)
PlotBounds(Th)
plt.axis('off')
plt.hold(False)

plt.figure(2)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,x)

if not run_from_ipython():
  wait = input("PRESS ENTER TO CONTINUE.") 