import matplotlib.pyplot as plt
import numpy as np
import sys,os
sep=os.path.sep
ToolBoxDir=os.path.abspath(os.path.dirname(os.path.abspath(__file__))+sep+"..")
sys.path.append(ToolBoxDir)

from pyVecFEMP1Light.mesh import HyperCube
from pyVecFEMP1Light.pde import initPDE,setBC_PDE,solvePDE
from pyVecFEMP1Light.operators import Hoperator,Loperator
from pyVecFEMP1Light.common import  mkdir_p,run_from_ipython
from pyVecFEMP1Light.paraview import vtkWriteValues

sep=os.path.sep
VTKsaveDir=ToolBoxDir+sep+'vtk'
Name="elasticity3D"

from math import pi,cos,sin

d=3;m=3

Num=1
E = 21.5e4; nu = 0.45
mu= E/(2*(1+nu))
lam = E*nu/((1+nu)*(1-2*nu))
trans=lambda q: np.c_[q[:,0]+np.sin(4*pi*q[:,1]), 10*q[:,1]-1, q[:,2]+np.cos(4*pi*q[:,1])]
#trans=lambda q: np.c_[2*q[:,0]-1,10*q[:,1], 2*q[:,2]-1]

print('1. Build mesh using HyperCube function')
Th=HyperCube(d,[10,50,10],trans=trans)
print('  -> Mesh sizes : nq=%d, nme=%d, nbe=%d'%(Th.nq,Th.nme,Th.nbe));

print('2. Set elasticity 3d problem')
gam=lam+2*mu
Hop=Hoperator(d=d,m=m)
Hop.H[0][0]=Loperator(d=d,A=[[gam,None,None],[None,mu,None],[None,None,mu]]) 
Hop.H[0][1]=Loperator(d=d,A=[[None,lam,None],[mu,None,None],[None,None,None]]) 
Hop.H[0][2]=Loperator(d=d,A=[[None,None,lam],[None,None,None],[mu,None,None]]) 
Hop.H[1][0]=Loperator(d=d,A=[[None,mu,None],[lam,None,None],[None,None,None]]) 
Hop.H[1][1]=Loperator(d=d,A=[[mu,None,None],[None,gam,None],[None,None,mu]])
Hop.H[1][2]=Loperator(d=d,A=[[None,None,None],[None,None,lam],[None,mu,None]])
Hop.H[2][0]=Loperator(d=d,A=[[None,None,mu],[None,None,None],[lam,None,None]])
Hop.H[2][1]=Loperator(d=d,A=[[None,None,None],[None,None,mu],[None,lam,None]])
Hop.H[2][2]=Loperator(d=d,A=[[mu,None,None],[None,mu,None],[None,None,gam]])
# One can also use the preset operator function
#   Hop=StiffElasHoperators(d,lam,mu)
pde=initPDE(Hop,Th)

pde.f=[0,0,-1]
pde=setBC_PDE(pde,3,[0,1,2],'Dirichlet',[0,0,0],None)

print('3. Solve elasticity 3D problem')
x,info=solvePDE(pde,Num=Num,split=True,verbose=True)
print(info)

print('4. Save datas in vtk file')
mkdir_p(VTKsaveDir)
vtkFileName='%s%s%s.vtk'%(VTKsaveDir,sep,Name)
U=np.zeros((Th.nq,3));U[:,0]=x[0];U[:,1]=x[1];U[:,2]=x[2];
vtkWriteValues(vtkFileName,Th,[U],['U'])
print(' -> save in file %s.\n'%vtkFileName)

print('PARAVIEW visualization')
print(' -> To see mesh deformation (scaled by factor 3) with ParaView (version >= 4.2.0)')
print('    From directory\n       %s\n    run system command :'%ToolBoxDir)
print('       paraview --state=vtk/elasticity3d.pvsm')