import matplotlib.pyplot as plt
import numpy as np
import sys,os
sep=os.path.sep
ToolBoxDir=os.path.abspath(os.path.dirname(os.path.abspath(__file__))+sep+"..")
sys.path.append(ToolBoxDir)

from pyVecFEMP1Light.mesh import readFreeFEM
from pyVecFEMP1Light.pde import initPDE,setBC_PDE,solvePDE
from pyVecFEMP1Light.operators import Loperator
from pyVecFEMP1Light.common import  run_from_ipython
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds

plt.close("all")

MeshDir=ToolBoxDir+sep+'meshes'+sep+'2D'
d=2

MeshFile=MeshDir+os.path.sep+'condenser2d-10.msh'
print('1. Get mesh %s using pyVecFEMP1Light'%MeshFile)
Th=readFreeFEM(MeshDir+os.path.sep+'condenser2d-10.msh')
print('  -> Mesh sizes : nq=%d, nme=%d, nbe=%d'%(Th.nq,Th.nme,Th.nbe))

print('2. Set condenser 2D problem')
Lop=Loperator(d=d,A=[[1,None],[None,1]])
pde=initPDE(Lop,Th)
pde=setBC_PDE(pde,1, 0,'Dirichlet', 0.,None)
pde=setBC_PDE(pde,99,0,'Dirichlet', 1.,None)
pde=setBC_PDE(pde,98,0,'Dirichlet',-1.,None)

print('3. Solve condenser 2D problem')
x=solvePDE(pde)

plt.ion() # interactive mode
plt.figure(1)
plt.clf()
plt.hold(True)
PlotMesh(Th)
PlotBounds(Th)
plt.axis('off')
plt.hold(False)

plt.figure(2)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,x)

if not run_from_ipython():
  wait = input("PRESS ENTER TO CONTINUE.") 
