import matplotlib.pyplot as plt

from pyVecFEMP1Light.FEM import *
from pyVecFEMP1Light.mesh import *
from pyVecFEMP1Light.pde import *
from pyVecFEMP1Light.operators import *
from pyVecFEMP1Light.common import *
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds,FillMesh
from matplotlib.text import Text
from math import cos

plt.close("all")

d=2
#N=int(input("N="))
N=50
print("1. Set %dD hypercube mesh"%d)
Th=HyperCube(d,N)
print("  -> Mesh sizes : nq=%d, nme=%d, nbe=%d" % (Th.nq,Th.nme,Th.nbe));

print("2. Set BVP : 2D Laplace")
Lop=Loperator(d=d,A=[[1,None],[None,1]])
pde=initPDE(Lop,Th)
pde=setBC_PDE(pde,1,0,'Dirichlet',0,None)
pde=setBC_PDE(pde,2,0,'Dirichlet',1,None)
pde=setBC_PDE(pde,3,0,'Robin',-0.5,lambda x1,x2: 1+x1**2+x2**2)
pde=setBC_PDE(pde,4,0,'Neumann',0.5,None)
pde.f=lambda x1,x2: cos(x1+x2)

print("3. Solve BVP")
x=solvePDE(pde)

print("4. Post-processing")
plt.ion() # interactive mode
plt.figure(1)
plt.clf()
plt.hold(True)
#PlotMesh(Th)
FillMesh(Th)
PlotBounds(Th,linewidth=4)
fig = plt.gcf()
ax = fig.gca()
ax.text(0.5,0.5,r'$\Omega=[0,1]\times[0,1]$',horizontalalignment='center',fontsize=16)
plt.axis('off')
plt.title('2D Hypercube')
plt.hold(False)

plt.figure(2)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,x)
plt.title(r'2D Laplace : solution (mesh $n_q=%d$, $n_{me}=%d$)'%(Th.nq,Th.nme))
