from pyVecFEMP1Light import *
import numpy as np
PrintCopyright()
print('Solving 2D Poisson BVP in a distorted domain')
print('1. Creating the mesh')
trans=lambda q: np.c_[20*q[:,0],
      2*(2*q[:,1]-1+np.cos(2*pi*q[:,0]))]
Th=HyperCube(2,[100,20],trans=trans)
print('2. Definition of the BVP')
LOp=Loperator(d=2,A=[[1,0],[0,1]])
pde=initPDE(LOp,Th)
pde=setBC_PDE(pde,1,0,'Dirichlet',0.,None)
pde=setBC_PDE(pde,2,0,'Dirichlet',1.,None)
pde=setBC_PDE(pde,3,0,'Robin',-0.5, 
	      lambda x,y: 1+x**2+y**2)
pde=setBC_PDE(pde,4,0,'Neumann',0.5,None)
pde.f=lambda x,y: cos(x+y)
print('3. Solving BVP');
uh=solvePDE(pde)

print("4. Post-processing")
import matplotlib.pyplot as plt
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds,FillMesh
plt.close("all")

plt.ion() # interactive mode
plt.figure(1)
plt.clf()
plt.hold(True)
FillMesh(Th)
PlotBounds(Th,linewidth=4)
plt.axis('off')
plt.title('Poisson2DTrans : domain $\Omega$ and boundaries')
plt.hold(False)

plt.figure(2)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,uh)
plt.title(r'Poisson2DTrans : solution (mesh $n_q=%d$, $n_{me}=%d$)'%(Th.nq,Th.nme))
pause("PRESS ENTER TO CONTINUE.")