# Copyright (C) 2015  Cuvelier F. and Scarella G. 
#   (LAGA/CNRS/University of Paris XIII)
#   see README for details
from pyVecFEMP1Light import *
import sys
PrintCopyright()
print('Solving 2D stationary convection-diffusion BVP')

print("1. Reading of the mesh")
Th=readFreeFEM("meshes/2D/sampleD2d01-20.msh")
print("2. Definition of the BVP")
af=lambda x,y: 0.1+(y-0.5)*(y-0.5)
Vx=lambda x,y: -10*y;Vy=lambda x,y: 10*x
b=0.01;g2=4;g4=-4;
f=lambda x,y: -200*exp(-((x-0.75)**2+y**2)\
			 /(0.1));
Lop=Loperator(d=Th.d,A=[[af,None],[None,af]],
	      c=[Vx,Vy],a0=b)
pde=initPDE(Lop,Th)
pde=setBC_PDE(pde,2,0, 'Dirichlet',g2)
pde=setBC_PDE(pde,4,0, 'Dirichlet',g4)
pde=setBC_PDE(pde,20,0,'Dirichlet',0)
pde=setBC_PDE(pde,21,0,'Dirichlet',0)
pde.f=f

print('3. Build 2D Poisson linear system')
A,b,ID,IDc,gD=buildPDEsystem(pde)

print("4. Solving BVP")
x=np.zeros((Th.nq,))
x[ID]=gD[ID]
bb=b[IDc]-A[IDc,::]*gD;
x[IDc]=spsolve((A[IDc])[::,IDc],bb)

print("5. Post-processing")
import matplotlib.pyplot as plt
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds,FillMesh,showSparsity
plt.close("all")

plt.ion() # interactive mode
plt.figure(1)
showSparsity(A)
plt.figure(2)
plt.clf()
plt.hold(True)
#PlotMesh(Th)
FillMesh(Th)
PlotBounds(Th,linewidth=4)
plt.axis('off')
plt.title(r'$\Omega$')
plt.hold(False)

plt.figure(3)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,x)
plt.title(r'Numerical solution ( $n_q=%d$, $n_{me}=%d$)'%(Th.nq,Th.nme))

pause("PRESS ENTER TO CONTINUE.")
