# Copyright (C) 2015  Cuvelier F. and Scarella G. 
#   (LAGA/CNRS/University of Paris XIII)
#   see README for details
from pyVecFEMP1Light import *
import sys
PrintCopyright()
print('Solving 3D stationary convection-diffusion BVP')

print("1. Reading of the mesh")
Th=readFreeFEM3D("meshes/3D/sampleD3d01-6.mesh")
print("2. Definition of the BVP")
af=lambda x,y,z: 0.7+z/10
Vx=lambda x,y,z: -10*y;Vy=lambda x,y,z: 10*x;Vz=lambda x,y,z: 10*z
f=lambda x,y,z: -800.0*exp(-10*((x-0.65)**2+y*y+(z-0.5)**2))+\
                 800.0*exp(-10*((x+0.65)**2+y*y+(z-0.5)**2))
Lop=Loperator(d=3,A=[[af,None,None],[None,af,None],[None,None,af]],\
                  c=[Vx,Vy,Vz], a0=0.01)
pde=PDE(Lop,Th)
pde=setBC_PDE(pde,20,0,'Robin',-0.05,1)
pde=setBC_PDE(pde,21,0,'Robin',0.05,1)
pde.f=f
print("3. Solving BVP")
x=solvePDE(pde)

print("4. Post-processing")
from pyVecFEMP1Light.paraview import vtkWriteValues
print('  *** Saving data in vtk file')
vtkFileName='vtk/StationaryConvDiff3D.vtk'
mkdir_p('vtk')
vtkWriteValues(vtkFileName,Th,[x],['U'])
print(' -> saved in file %s.'%vtkFileName)
print(' -> PARAVIEW visualization')
print('    To see solution with ParaView (version >= 4.2.0)')
print('      run system command :')
print('        paraview --state=samples/StationaryConvDiff3D.pvsm')
pause("PRESS ENTER TO CONTINUE.")
