# Copyright (C) 2015  Cuvelier F. and Scarella G. 
#   (LAGA/CNRS/University of Paris XIII)
#   see README for details
from pyVecFEMP1Light import *
import sys
PrintCopyright()
print('Solving 2D condenser BVP')

print("1. Reading of the condenser mesh")
Th=readFreeFEM('meshes/2D/condenser2d-10.msh')
print("2. Definition of the BVP : 2D condenser")
Lop=Loperator(d=Th.d,A=[[1,None],[None,1]])
pde=initPDE(Lop,Th)
pde=setBC_PDE(pde,1,0,'Dirichlet',0.,None)
pde=setBC_PDE(pde,99,0,'Dirichlet',1.,None)
pde=setBC_PDE(pde,98,0,'Dirichlet',-1.,None)
print("3. Solving BVP")
x=solvePDE(pde)

print("4. Post-processing")
import matplotlib.pyplot as plt
from pyVecFEMP1Light.graphics import PlotVal,PlotMesh,PlotBounds,FillMesh
plt.close("all")

plt.ion() # interactive mode
plt.figure(1)
plt.clf()
plt.hold(True)
FillMesh(Th)
PlotBounds(Th,linewidth=4)
plt.axis('off')
plt.title('2D condenser : domain $\Omega$ and boundaries')
plt.hold(False)

plt.figure(2)
plt.clf()
plt.hold(True)
PlotBounds(Th,legend=False,color='k')
plt.axis('off')
PlotVal(Th,x)
plt.title(r'2D condenser : solution (mesh $n_q=%d$, $n_{me}=%d$)'%(Th.nq,Th.nme))

pause("PRESS ENTER TO CONTINUE.")
