%  NAME 
%   [Elem]=VecElemStiffElas2DP5(ql,area,lambda,mu)
%  INPUTS 
%   area 	: double (element area)
%   ql    	: matrix 2x3
%         	  ql(:,il) ...
%   lambda 	:  scalar ...
%   mu     	:  scalar ...
%  OUTPUTS 
%   Elem 	: matrix 42x42
%  DESCRIPTION
%   Compute P5-Lagrange elementary Stiff Elasticity matrix.
%   C=[L + 2*M       L       0]
%     [      L L + 2*M       0]
%     [      0       0       M]
%   Numbering of local points in reference element is :
%     P=[(0, 0), (1/5, 0), (2/5, 0), (3/5, 0), (4/5, 0), (1, 0), (0, 1/5), (1/5, 1/5), (2/5, 1/5), (3/5, 1/5), (4/5, 1/5), (0, 2/5), (1/5, 2/5), (2/5, 2/5), (3/5, 2/5), (0, 3/5), (1/5, 3/5), (2/5, 3/5), (0, 4/5), (1/5, 4/5), (0, 1)]
% ----------------------------------------
%  (c) Cuvelier F. email:cuvelier@math.univ-paris13.fr
%
% Development informations :
%   MD5SUM            : 2ecf0d3b9f1220b9f921b241750bbaa9  VecElemStiffElas2DP5.m
%   GIT current commit: commit 709958b9b037f076150c70acea077b5e3d832dc0
%   GIT current branch: * master
