function [M]=AssemblyMassPkOptV2(Th,k)
% function M=AssemblyMassPkOptV2(Th,k)
%    Assembly of the Mass matrix with Pk-Lagrange finite elements 
%    on the mesh given by Th. Using algorithm version OptV2.
%    In 2D, k is in [1,5] and in 3D, k is 1 or 2.
%    The mesh Th must be initialized by setMeshPk function.
%
% inputs
%    Th : 2D or 3D mesh structure (see HyperCube for generic description)
%    k  : integer, order of the Pk-Lagrange
%
% output
%    M  : sparse Mass matrix 
% 
% see also
%    GetMesh2D, GetMesh3D, HyperCube, 
%    setMesh2DPk, setMesh3DPk, setMeshPk
%
% sample
%    Th=HyperCube(2,50);
%    Th=setMeshPk(Th,3);
%    M=AssemblyMassPkOptV2(Th,k);
%
  checkMeshOrder(Th,k)
  if (k==1), ndof=Th.nq;mef=Th.me; else
    ndof=Th.Pk.nq;mef=Th.Pk.me;
  end

  [Ig,Jg]=BuildIgJgPk(Th.d,k,mef);
  Kg=eval(sprintf('VecElemMass%dDP%d(Th.vols)',Th.d,k));
  M = sparse(Ig(:),Jg(:),Kg(:),ndof,ndof);
end