function S=AssemblingStiffElasPkOptV0(Th,lambda,mu,Num,k)
% function M=AssemblyStiffElasPkOptV0(Th,k)
%    Assembly of the Stiffness Elasticity matrix with Pk-Lagrange finite elements 
%    on the mesh given by Th. Using algorithm version OptV0.
%    In 2D, k is in [1,5] and in 3D, k is 1 or 2.
%    The mesh Th must be initialized by setMeshPk function.
%
% inputs
%      Th : 2D or 3D mesh structure (see HyperCube for generic description)
%  lambda : 1st Lame's parameter
%      mu : 2nd Lame's parameter
%     Num : Num=0, glocal alternate basis. Num=1, global block basis
%      k  : integer, order of the Pk-Lagrange
%
% output
%    M  : sparse Stiffness Elasticity matrix 
% 
% see also
%    GetMesh2D, GetMesh3D, HyperCube, 
%    setMesh2DPk, setMesh3DPk, setMeshPk
%
% sample
%    Th=HyperCube(2,50);
%    Th=setMeshPk(Th,3);
%    M=AssemblyStiffElasPkOptV0(Th,0.1,0.3,0,k);
%
  checkMeshOrder(Th,k)
  if (k==1), ndof=Th.nq;nmef=Th.nme;mef=Th.me; else
    ndof=Th.Pk.nq;nmef=Th.Pk.nme;mef=Th.Pk.me;
  end
  ndf=size(mef,1);m=Th.d;
  dim=m*ndf;
  if Th.d==2
    LI=[1:2:dim,2:2:dim];
    if Num==0
      GetI=@(me,k) [2*me(:,k)-1;2*me(:,k)];
    else
      GetI=@(me,k) [me(:,k);me(:,k)+ndof];
    end
  else
    LI=[1:3:dim,2:3:dim,3:3:dim];
    if Num==0
      GetI=@(me,k) [3*me(:,k)-2;3*me(:,k)-1;3*me(:,k)];
    else
      GetI=@(me,k) [me(:,k);me(:,k)+ndof;me(:,k)+2*ndof;];
    end
  end

  Elem=eval(sprintf('@(ql,vol) ElemStiffElas%dDP%d(ql,vol,%.16f,%.16f);',Th.d,k,lambda,mu));
  S=sparse(m*ndof,m*ndof);
  for kk=1:nmef  
      I(LI)=GetI(mef,kk);
      S(I,I)=S(I,I)+Elem(Th.q(:,Th.me(:,kk)),Th.vols(kk));
  end
end
