function R=AssemblingStiffElasPkOptV2(Th,lambda,mu,Num,k)
% function M=AssemblyStiffElasPkOptV2(Th,k)
%    Assembly of the Stiffness Elasticity matrix with Pk-Lagrange finite elements 
%    on the mesh given by Th. Using algorithm version OptV2.
%    In 2D, k is in [1,5] and in 3D, k is 1 or 2.
%    The mesh Th must be initialized by setMeshPk function.
%
% inputs
%      Th : 2D or 3D mesh structure (see HyperCube for generic description)
%  lambda : 1st Lame's parameter
%      mu : 2nd Lame's parameter
%     Num : Num=0, glocal alternate basis. Num=1, global block basis
%      k  : integer, order of the Pk-Lagrange
%
% output
%    M  : sparse Stiffness Elasticity matrix 
% 
% see also
%    GetMesh2D, GetMesh3D, HyperCube, 
%    setMesh2DPk, setMesh3DPk, setMeshPk
%
% sample
%    Th=HyperCube(2,50);
%    Th=setMeshPk(Th,3);
%    M=AssemblyStiffElasPkOptV2(Th,0.1,0.3,0,k);
%
  checkMeshOrder(Th,k)
  if (k==1), ndof=Th.nq;nmef=Th.nme;mef=Th.me; else
    ndof=Th.Pk.nq;nmef=Th.Pk.nme;mef=Th.Pk.me;
  end
  [Ig,Jg]=BuildIgJgVFPk(Th.d,k,mef,ndof,Num);
  Kg=eval(sprintf('VecElemStiffElas%dDP%d(Th.q,Th.me,Th.vols,lambda,mu)',Th.d,k));
  R = sparse(Ig(:),Jg(:),Kg(:),Th.d*ndof,Th.d*ndof);
end
