function F=EvalFuncOnMesh(f,q)
% function F=EvalFuncOnMesh(f,q)
%    Evaluate vector field function f on points q 
% 
% inputs
%      f   a scalar or a function handle.
%      q   d-by-nq array, array of nq points in dimension d
%      k   order of Pk-Lagrange finite element
%
% output
%      F   nq-by-1 array. We note qi=(q(1,i),...,q(d,i)) and we have
%          F(i)=f(qi) 
%          
% sample
%      Th=Hypercube(2,10);
%      f=@(x,y) cos(x+y);
%      F=EvalFuncOnMesh(f,Th.q);
%      g=2;
%      G=EvalFuncOnMesh(g,Th.q);
%
%----------------------------------------
% (c) Cuvelier F. email:cuvelier@math.univ-paris13.fr
%
  d=size(q,1);
  if isfhandle(f)
    F=eval(['f(q(1,:)',sprintf(',q(%d,:)',2:d),').'';']) ; 
    if (length(F)==1) % f == constant
      F=F*ones(size(q,2),1);
    end
    return
  end
  if isnumeric(f) && isscalar(f)
    F=f*ones(size(q,2),1);
  end
end