function F=EvalFuncOnMeshPk(f,Th,k)
% function F=EvalFuncOnMeshPk(f,Th,k)
%    Evaluate function f on Mesh Th with Pk-Lagrange finite element
% 
% inputs
%      f   a scalar or a function handle.
%     Th   mesh structure (initialized with setMeshPk function)
%      k   order of Pk-Lagrange finite element
%
% output
%      F   N-by-1 array with N=Th.Pk.nq
%          We note qi=(Th.Pk.q(1,i),...,Th.Pk.q(d,i)) and we have :
%            F(i)=f(qi) 
%          
% sample
%      Th=Hypercube(2,10);
%      Th=setMeshPk(Th,3);
%      f=@(x,y) cos(x+y);
%      F=EvalFuncOnMeshPk(f,Th,3);
%      g=2;
%      G=EvalFuncOnMeshPk(g,Th,3);
%
%----------------------------------------
% (c) Cuvelier F. email:cuvelier@math.univ-paris13.fr
%
  checkMeshOrder(Th,k)
  d=Th.d;
  if (k==1), q=Th.q; else q=Th.Pk.q; end
  F=EvalFuncOnMesh(f,q);
end