function fd=EvalFuncVFOnMesh(f,q,Num)
% function fd=EvalFuncVFOnMesh(f,q,Num)
%    Evaluate vector field function f on points q 
%    in : global alternate basis (Num==0)
%         global block basis (Num==1)
% 
% inputs
%      f   vector field function given by 1-by-m cell of scalar or 
%          function handle f={f1,...,fm}. In Elasticity m=Th.d.
%     q    d-by-nq array, array of nq points in dimension d
%    Num   global basis choice (Num=0 or 1)
%
% output
%      F   N-by-1 array with N=m*nq
%          We note qi=(q(1,i),...,q(d,i)) and we have :
%          if Num==0 (global alternate basis)
%            F(d(i-1)+1)=f1(qi),..., F(d(i-1)+m)=f(qi), 
%          if Num==1 (global block basis)
%            F(i)=f1(qi),..., F(i+(m-1)*nq)=fd(qi), 
%          
% sample
%      Th=Hypercube(2,10);
%      f={@(x,y) cos(x+y), @(x,y) sin(x+y)};
%      F=EvalFuncVFOnMesh(f,Th.q,0);
%      g={@(x,y) cos(x+y), 0};
%      G=EvalFuncVFOnMesh(g,Th.q,0);
%
%----------------------------------------
% (c) Cuvelier F. email:cuvelier@math.univ-paris13.fr
  assert(iscell(f));
  m=length(f);
  nq=size(q,2);
  fd=zeros(m*nq,1);E=1:nq;
  VFInd=getVFindices(Num,m,nq);
  for i=1:m
    fd(VFInd(E,i))=EvalFuncOnMesh(f{i},q);
  end
end