function F=EvalFuncVFOnMeshPk(f,Th,Num,k)
% function fd=EvalFuncVFOnMeshPk(f,Th,Num,k)
%    Evaluate vector field function on Mesh Th with Pk-Lagrange finite element
%    in : global alternate basis (Num==0)
%         global block basis (Num==1)
% 
% inputs
%      f   vector field function given by 1-by-m cell of scalar or 
%          function handle f={f1,...,fm}. In Elasticity m=Th.d.
%     Th   mesh structure (initialized with setMeshPk function)
%    Num   global basis choice (Num=0 or 1)
%      k   order of Pk-Lagrange finite element
%
% output
%      F   N-by-1 array with N=m*Th.Pk.nq
%          We note qk^i=(Th.Pk.q(1,i),...,Th.Pk.q(d,i)) and we have :
%          if Num==0 (global alternate basis)
%            F(d(i-1)+1)=f1(qk^i),..., F(d(i-1)+m)=fd(qk^i), 
%          if Num==1 (global block basis)
%            F(i)=f1(qk^i),..., F(i+(m-1)*nq)=fd(qk^i), 
%          
% sample
%      Th=Hypercube(2,10);
%      Th=setMeshPk(Th,3);
%      f={@(x,y) cos(x+y), @(x,y) sin(x+y)};
%      F=EvalFuncVFOnMeshPk(f,Th,0,3);
%      g={@(x,y) cos(x+y), 0};
%      G=EvalFuncVFOnMeshPk(g,Th,0,3);
%
%----------------------------------------
% (c) Cuvelier F. email:cuvelier@math.univ-paris13.fr
%
  checkMeshOrder(Th,k)
  d=Th.d;
  if (k==1), q=Th.q; else q=Th.Pk.q; end
  F=EvalFuncVFOnMesh(f,q,Num);
end