%  function Th=HyperCube(d,N)
%     generate a d-simplex Mesh structure of the hypercube [0,1]^d
%     with N regular points in each direction.
% 
%  inputs
%     d   space dimension (d>=1)
%     N   number of points of the discretization in each dimension.
%         So there are N^d in the Mesh structure
% 
%  output
%     Th  the Mesh structure
% 
%  Generated fields of Mesh
%       d: space dimension 
%      nq: total number of vertices
%     nme: total number of mesh elements (d-simplex)
%     nbe: total number of boundary elements ((d-1)-simplex)
%       q: Array of vertices coordinates, d-by-nq array.
%          q(il,j) is the il-th coordinate of the j-th vertex, il in {1,...,d}
%          and j in {1,...,nq}.
%      me: Connectivity array, (d+1)-by-nme array.
%          me(jl,k) is the storage index of the jl-th  vertex 
%          of the k-th triangle in the array q of vertices coordinates,
%          jl in {1,...,d+1} and k in {1,...,nme}.
%      ql: Array of vertices labels, 1-by-nq array.
%     mel: Array of elements labels, 1-by-nme array.
%      be: Connectivity array for boundary elements, d-by-nbe array.
%          be(il,l) is the storage index of the il-th  vertex 
%          of the l-th boundary elements in the array q of vertices coordinates,
%          il in {1,...,d} and l in {1,...,nbe}.
%     bel: Array of boundary elements labels, 1-by-nbe array. 
%    vols: Array of volumes, 1-by-nme array. vols(k) is the volume 
%          of the k-th mesh elements.
% 
%
% Development informations :
%   MD5SUM            : 0e57921d7b14bece4667458bc7a27da2  HyperCube.m
%   GIT current commit: commit 709958b9b037f076150c70acea077b5e3d832dc0
%   GIT current branch: * master
