clear all
close all

%-----------------------------------------------------
% Parameters (can be modified)
d=2;   % space dimension d=2 or d=3
k=4;   % Pk-Lagrange order k in 1..5 for d==2, k=1 or 2 for d==3
N=10;  % Hypercube Mesh refinement parameter  
Num=1; % For Elasticity only : Num=1, global block basis - Num=0, global alternate basis
%-----------------------------------------------------
checkDimOrder(d,k)

% 1) Get Mesh from file and build Pk-Lagrange finite elements structure
if (d==2)
  Th=GetMesh2D('disk4-1-50.msh');
else
  Th=GetMesh3D('sphere-1-2.mesh','format','medit');
end
Th=setMeshPk(Th,k); % 
fprintf('%dD Mesh : \n',d)
fprintf('   number of vertices     nq = %d\n',Th.nq)
fprintf('   number of %d-simplices nme = %d\n',Th.d,Th.nme)
fprintf('P%d-Lagrange Finite Elements\n',k)
fprintf('   number of local degrees of freedom  : %d\n', getPkDoF(d,k))
if k==1, ndof=Th.nq; else ndof=Th.Pk.nq; end
fprintf('   number of global degrees of freedom : %d\n', ndof)

% 2) Assembly Mass matrix 
fprintf('2) Building Mass matrix (d=%d,k=%d) ...\n',d,k)
Mass=AssemblyMassPkOptV2(Th,k);
fprintf('    Matrix size : %d-by-%d\n',size(Mass,1),size(Mass,2))

% 3) Assembly Weight Mass matrix 
fprintf('3) Building MassW matrix (d=%d,k=%d) ...\n',d,k)
if d==2, w=@(x,y) cos(x+y)+2; else  w=@(x,y,z) cos(x+y+z)+2; end % Weigth function
W=EvalFuncOnMeshPk(w,Th,k);
MassW=AssemblyMassWPkOptV2(Th,W,k);
fprintf('    Matrix size : %d-by-%d\n',size(MassW,1),size(MassW,2))

% 4) Assembly Stiffness matrix
fprintf('4) Building Stiff matrix (d=%d,k=%d) ...\n',d,k)
Stiff=AssemblyStiffPkOptV2(Th,k);
fprintf('    Matrix size : %d-by-%d\n',size(Stiff,1),size(Stiff,2))

% 5) Assembly Stiffness Elasticity matrix
fprintf('5) Building StiffElas matrix (d=%d,k=%d) ...\n',d,k)
Basis={'global alternate basis','global block basis'};
fprintf('    Num == %d, %s\n',Num,Basis{Num+1});
% E : module d'Young
% iridium (Ir): 528 Gpa (metal pur)
% fer     (Fe): 196 Gpa
% etain   (Sn): 41,5 Gpa
% plomb   (Pb): 18 Gpa   
%
% Chene (bois) : 12 Gpa
% Fibre de carbonne (haut module) : 640 Gpa
% 
% caoutchouc 0.001 à 0.1 Gpa (polymère)
%
E=41.5e9;
% nu : coefficient de Poisson dans ]-1;0.5[
%      generalement proche de 0.3
nu=0.3;
mu  =  E/(2*(1+nu));
lambda =  E*nu/((1+nu)*(1-2*nu));
fprintf('    Young''s modulus, E = %g - Poisson''s ratio, nu = %g\n',E,nu)
fprintf('    Lame''s parameters, lambda = %g, mu = %g\n',lambda,mu);
StiffElas=AssemblyStiffElasPkOptV2(Th,lambda,mu,Num,k);
fprintf('    Matrix size : %d-by-%d\n',size(StiffElas,1),size(StiffElas,2))

spy(StiffElas)
title(sprintf('Sparsity pattern of StiffElas matrix (d=%d,k=%d,Num=%d)\n',d,k,Num))