function Mesh=GetMesh2DOpt(cFileName,varargin)
% Mesh=GetMesh2DOpt(cFileName)
%   Read FreeFem 2D-mesh
%
% Parameter :
%   cFileName : mesh filename 
% Output :
%   Mesh, a mesh structure (see setMesh.m)
% Mesh=GetMesh3DOpt(cFileName,varargin)
%   Read 3D-mesh in format :
%     - FreeFem++, 
%     - medit,
%     - gmsh.
%
% Parameter :
%   cFileName : mesh filename 
% Optional parameter :
%   'format' : 'freefem' (default) or 'gmsh'
% Output :
%   Mesh, a mesh structure (see setMesh.m)
%
  p = inputParser; 
  if isOctave()
    p=p.addParamValue('format', 'freefem', @ischar );
    p=p.parse(varargin{:});
  else
    p.addParamValue('format', 'freefem', @ischar );
    p.parse(varargin{:});
  end

  Format=p.Results.format;
  % FC -> a ameliorer avec une liste des formats dispo et 
  %       utilisation + generique GetMesh%s...
  if (strcmp(Format,'freefem')) 
    Mesh=GetFreefemMesh(cFileName);
    return;
  end

  if (strcmp(Format,'gmsh'))
    Mesh=GetGmshMesh(cFileName);
    return;
  end
  
end

function Mesh=GetFreefemMesh(cFileName)
%
  [fid,message]=fopen(cFileName,'r');
  if ( fid == -1 )
    error([message,' : ',cFileName]);
  end
  if isOctave()
    [n]=fscanf(fid,'%d %d %d',3);

    R=fscanf(fid,'%f %f %d',[3,n(1)]);
    q=R([1 2],:);
    ql=R(3,:);
    R=fscanf(fid,'%d %d %d %d',[4,n(2)]);

    me=R([1:3],:);
    mel=R(4,:);
    R=fscanf(fid,'%d %d %d',[3,n(3)]);
    
    be=R([1 2],:);
    bel=R(3,:);
  else % Matlab
    n=textscan(fid,'%d %d %d',1); % n(1) -> number of vertices
			% n(2) -> number of triangles
			% n(3) -> number of boundary edges
    
    R=textscan(fid,'%f %f %d',n{1});
    q=[R{1},R{2}]';
    ql=R{3}';
    R=textscan(fid,'%d %d %d %d',n{2});
    me=[R{1},R{2},R{3}]';
    mel=R{4}';

    R=textscan(fid,'%d %d %d',n{3});
    be=[R{1},R{2}]';
    bel=R{3}';
  end
  fclose(fid);
  Mesh=setMesh(2,size(q,2),size(me,2),size(be,2),q,double(me),double(be),double(mel),double(bel));
%    Mesh=struct('d',2,'q',q,'me',double(me),'ql',ql,'mel',double(mel), ...
%  	      'be',double(be),'bel',double(bel), ...
%  	      'nq',size(q,2), ...
%  	      'nme',size(me,2), ...
%  	      'nbe',size(be,2), ...
%  	      'vols',ComputeVolVec(2,q,me), ...
%  	      'h',GetMaxLengthEdges(q,me));
end

% Read gmsh meshes
function Th=GetGmshMesh(cFileName)
  msh=load_gmsh(cFileName);
  assert(msh.nbTets==0)
  nq=msh.nbNod;
  q=msh.POS(:,1:2)';
  nme=msh.nbTriangles;
  me=msh.TRIANGLES(1:nme,1:3)';
  mel=msh.TRIANGLES(1:nme,4);
  nbe=msh.nbLines;
  be=msh.LINES(1:nbe,1:2)';
  bel=msh.LINES(1:nbe,3);
  Th=setMesh(2,nq,nme,nbe,q,me,be,mel,bel);
end